︠65e699b4-7390-4927-92b3-c162ce7de015s︠
f(x) = x^2 -1

@interact
def myIntegralPlot( a = slider(-2, 2, 0.05, -1.5 ), b = slider(-2, 2, 0.05, 1 ) ):
    epsilon = 10^-12

    # this takes care of several different drawing issues
    # whenever b < a, or in other words, the bounds are backwards.
    left_bound = min( a, b )
    right_bound = max( a, b )

    # the 10^-12 in the next line might surprise you, but it is because the
    # program reacted badly when both a=1 and b=1.
    P1 = plot( f(x), x, left_bound, right_bound + epsilon, fill=True )
    P2 = plot( f(x), x, -2, 2, gridlines='minor', ymin=-2, ymax=3)
    P3 = text("$\\int_a^b ( x^2 - 1 ) \\; dx$", (0, -1.75), fontsize=24 )

    # this colored arrow avoids student confusion when bounds are backwards
    if (a < b):
        P4 = arrow( (-0.5, 0.99), (0.5, 1), color='green' )
        P = P4 + P1 + P2 + P3
    elif (b < a):
        P4 = arrow( (0.5, 1), (-0.5, 0.99), color='red' )
        P = P4 + P1 + P2 + P3
    else:
        # note, this is for the a=b case
        P = P1 + P2 + P3


    P.show()

    print()
    print("Final Value Roughly ", N( integral( f(x), x, a, b) ))

    return

︡a8f43228-a8dd-4531-8480-6dff66f29e0d︡{"interact":{"controls":[{"animate":true,"control_type":"slider","default":10,"display_value":true,"label":"a","vals":["-2.00000000000000","-1.95000000000000","-1.90000000000000","-1.85000000000000","-1.80000000000000","-1.75000000000000","-1.70000000000000","-1.65000000000000","-1.60000000000000","-1.55000000000000","-1.50000000000000","-1.45000000000000","-1.40000000000000","-1.35000000000000","-1.30000000000000","-1.25000000000000","-1.20000000000000","-1.15000000000000","-1.10000000000000","-1.05000000000000","-0.999999999999999","-0.949999999999999","-0.899999999999999","-0.849999999999999","-0.799999999999999","-0.749999999999999","-0.699999999999999","-0.649999999999999","-0.599999999999999","-0.549999999999999","-0.499999999999999","-0.449999999999999","-0.399999999999999","-0.349999999999999","-0.299999999999999","-0.249999999999999","-0.199999999999999","-0.149999999999999","-0.0999999999999988","-0.0499999999999988","1.20736753927986e-15","0.0500000000000012","0.100000000000001","0.150000000000001","0.200000000000001","0.250000000000001","0.300000000000001","0.350000000000001","0.400000000000001","0.450000000000001","0.500000000000001","0.550000000000001","0.600000000000001","0.650000000000001","0.700000000000001","0.750000000000001","0.800000000000001","0.850000000000002","0.900000000000002","0.950000000000002","1.00000000000000","1.05000000000000","1.10000000000000","1.15000000000000","1.20000000000000","1.25000000000000","1.30000000000000","1.35000000000000","1.40000000000000","1.45000000000000","1.50000000000000","1.55000000000000","1.60000000000000","1.65000000000000","1.70000000000000","1.75000000000000","1.80000000000000","1.85000000000000","1.90000000000000","1.95000000000000","2.00000000000000"],"var":"a","width":null},{"animate":true,"control_type":"slider","default":60,"display_value":true,"label":"b","vals":["-2.00000000000000","-1.95000000000000","-1.90000000000000","-1.85000000000000","-1.80000000000000","-1.75000000000000","-1.70000000000000","-1.65000000000000","-1.60000000000000","-1.55000000000000","-1.50000000000000","-1.45000000000000","-1.40000000000000","-1.35000000000000","-1.30000000000000","-1.25000000000000","-1.20000000000000","-1.15000000000000","-1.10000000000000","-1.05000000000000","-0.999999999999999","-0.949999999999999","-0.899999999999999","-0.849999999999999","-0.799999999999999","-0.749999999999999","-0.699999999999999","-0.649999999999999","-0.599999999999999","-0.549999999999999","-0.499999999999999","-0.449999999999999","-0.399999999999999","-0.349999999999999","-0.299999999999999","-0.249999999999999","-0.199999999999999","-0.149999999999999","-0.0999999999999988","-0.0499999999999988","1.20736753927986e-15","0.0500000000000012","0.100000000000001","0.150000000000001","0.200000000000001","0.250000000000001","0.300000000000001","0.350000000000001","0.400000000000001","0.450000000000001","0.500000000000001","0.550000000000001","0.600000000000001","0.650000000000001","0.700000000000001","0.750000000000001","0.800000000000001","0.850000000000002","0.900000000000002","0.950000000000002","1.00000000000000","1.05000000000000","1.10000000000000","1.15000000000000","1.20000000000000","1.25000000000000","1.30000000000000","1.35000000000000","1.40000000000000","1.45000000000000","1.50000000000000","1.55000000000000","1.60000000000000","1.65000000000000","1.70000000000000","1.75000000000000","1.80000000000000","1.85000000000000","1.90000000000000","1.95000000000000","2.00000000000000"],"var":"b","width":null}],"flicker":false,"id":"871ab5be-7854-41d2-9f39-73b5a3038b7a","layout":[[["a",12,null]],[["b",12,null]],[["",12,null]]],"style":"None"}}︡{"done":true}
︠0c8f979b-bf19-4fe7-ba8e-92b3c5364b66︠









